#include "mount.h"
#include "nfs_prot.h"

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*
 * Copyright (c) 1987, 1990 by Sun Microsystems, Inc.
 */

/* from @(#)nfs_prot.x	1.3 91/03/11 TIRPC 1.0 */

/* Fill this in and set the fh to that of the root of the system */
nfsstat 
nfs_get_root (nfs_fh *fh)
{

    return NFS_OK;
}


int
nfsproc_null_2_svc(void *argp, void *result, struct svc_req *rqstp)
{
    return TRUE;
}


int
nfsproc_getattr_2_svc(nfs_fh *argp, attrstat *result, struct svc_req *rqstp)
{

    return TRUE;
}

int
nfsproc_setattr_2_svc(sattrargs *argp, attrstat *result, struct svc_req *rqstp)
{
    /* some nfs clients don't set the file type in the attributes -- check */

    return TRUE;
}

int
nfsproc_root_2_svc(void *argp, void *result, struct svc_req *rqstp)
{
    /* Unimplemented -- Ignore */
    
    return TRUE;
}

int
nfsproc_lookup_2_svc(diropargs *argp, diropres *result, struct svc_req *rqstp)
{
    return TRUE;
}

int
nfsproc_readlink_2_svc(nfs_fh *argp, readlinkres *result,
                       struct svc_req *rqstp)
{
    /* Result for readlink path needs to be malloced */
    result->readlinkres_u.data = (char *) malloc (NFS_MAXPATHLEN);

    return TRUE;
}

int
nfsproc_read_2_svc(readargs *argp, readres *result, struct svc_req *rqstp)
{
    /* Result buffer for read needs to be malloced, size could be smaller */
    result->readres_u.reply.data.data_val = (char *) malloc (NFS_MAXDATA);

    return TRUE;
}

int
nfsproc_writecache_2_svc(void *argp, void *result, struct svc_req *rqstp)
{
    /* Unimplemented -- ignore */

    return TRUE;
}

int
nfsproc_write_2_svc(writeargs *argp, attrstat *result, struct svc_req *rqstp)
{
    return TRUE;
}

int
nfsproc_create_2_svc(createargs *argp, diropres *result, struct svc_req *rqstp)
{
    /* some nfs clients don't set the file type in the attributes -- check */

    return TRUE;
}

int
nfsproc_remove_2_svc(diropargs *argp, nfsstat *result, struct svc_req *rqstp)
{
    return TRUE;
}

int
nfsproc_rename_2_svc(renameargs *argp, nfsstat *result, struct svc_req *rqstp)
{
    return TRUE;
}

int
nfsproc_link_2_svc(linkargs *argp, nfsstat *result, struct svc_req *rqstp)
{
    return TRUE;
}

int
nfsproc_symlink_2_svc(symlinkargs *argp, nfsstat *result,
                      struct svc_req *rqstp)
{
    /* some nfs clients don't set the file type in the attributes -- check */
    
    return TRUE;
}

int
nfsproc_mkdir_2_svc(createargs *argp, diropres *result, struct svc_req *rqstp)
{
    /* some nfs clients don't set the file type in the attributes -- check */

    return TRUE;
}

int
nfsproc_rmdir_2_svc(diropargs *argp, nfsstat *result, struct svc_req *rqstp)
{
    return TRUE;
}

int
nfsproc_readdir_2_svc(readdirargs *argp, readdirres *result,
                      struct svc_req *rqstp)
{
    unsigned int cookie;

    /* To get the initial cookie value */
    cookie = ntohl (*(unsigned int *)argp->cookie);

    /* Each entry in the result structure needs to be malloced, set the last
       one's next pointer to NULL */

    /* Set the cookie in each entry using htonl and casting it appropriately */
    
    return TRUE;
}

int
nfsproc_statfs_2_svc(nfs_fh *argp, statfsres *result, struct svc_req *rqstp)
{
    return TRUE;
}

int
nfs_program_2_freeresult (SVCXPRT *transp, xdrproc_t xdrp, caddr_t res)
{
    xdr_free(xdrp, res);
    return TRUE;
}
 

/*
 * Local variables:
 *  c-basic-offset: 4
 *  indent-tabs-mode: nil
 * End:
 */
