#include <stdlib.h>
#include <stdio.h>
#include <map>

#include "nfs_prot.h"
#include "nfs_fh_cache.h"

using namespace std;

typedef struct pathname {
    char *path;
} pathname_t;

typedef map <nfs_fh, pathname_t> fh_map_t;

static fh_map_t fh_map;

static inline bool
operator<(const nfs_fh &a,
          const nfs_fh &b) 
{
    return (memcmp (a.data, b.data, NFS_FHSIZE) < 0);
};

static inline bool
operator==(const nfs_fh &a,
           const nfs_fh &b) 
{
    return (memcmp (a.data, b.data, NFS_FHSIZE) == 0);
};

void
nfs_fh_cache_insert (nfs_fh *fh, char *path)
{
    pathname_t pathname;
    
    pathname.path = (char *) malloc (strlen (path) + 1);
    strcpy (pathname.path, path);

    fh_map.insert (fh_map_t::value_type(*fh, pathname));
}

char *
nfs_fh_cache_lookup (nfs_fh *fh)
{
    fh_map_t::iterator i = fh_map.find (*fh);

    if (i == fh_map.end ()) {
        return NULL;
    }
    
    return i->second.path;
}

void
nfs_fh_cache_remove (nfs_fh *fh)
{
    char *path;

    path = nfs_fh_cache_lookup (fh);
    if (path != NULL) {
        free (path);
    }
    
    fh_map.erase (*fh);
}



/*
 * Local variables:
 *  c-basic-offset: 4
 *  indent-tabs-mode: nil
 * End:
 */
