#include "mount.h"
#include "nfs_prot.h"

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*
 * Copyright (c) 1985, 1990 by Sun Microsystems, Inc.
 */

/* from @(#)mount.x	1.3 91/03/11 TIRPC 1.0 */

extern nfsstat nfs_get_root (nfs_fh *fh);

int
mountproc_null_1_svc(void *argp, void *result, struct svc_req *rqstp)
{

    return TRUE;
}

int
mountproc_mnt_1_svc(dirpath *argp, fhstatus *result, struct svc_req *rqstp)
{
    /* Return the root filehandle */
    if (strcmp (*argp, "/") != 0) {
      result->fhs_status = NFSERR_ACCES;
    } else {
      result->fhs_status = nfs_get_root 
                                    ((nfs_fh *)result->fhstatus_u.fhs_fhandle);
    }

    return TRUE;
}

int
mountproc_dump_1_svc(void *argp, mountlist *result, struct svc_req *rqstp)
{
    /* Not needed -- ignore */

    return TRUE;
}

int
mountproc_umnt_1_svc(dirpath *argp, void *result, struct svc_req *rqstp)
{

    return TRUE;
}

int
mountproc_umntall_1_svc(void *argp, void *result, struct svc_req *rqstp)
{
    /* Not needed -- ignore */

    return TRUE;
}

int
mountproc_export_1_svc(void *argp, exports *result, struct svc_req *rqstp)
{
    /* Not needed -- ignore */

    return TRUE;
}

int
mountproc_exportall_1_svc(void *argp, exports *result, struct svc_req *rqstp)
{
    /* Not needed -- ignore */

    return TRUE;
}

int
mountprog_1_freeresult (SVCXPRT *transp, xdrproc_t xdrp, caddr_t res)
{
    xdr_free(xdrp, res);

    return TRUE;
}

/*
 * Local variables:
 *  c-basic-offset: 4
 *  indent-tabs-mode: nil
 * End:
 */
